//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
    #ifdef	normal
    	#define	p00	P0DR.bit.b0
    	#define	p01	P0DR.bit.b1
    #else	
     	#define	p00	P2DR.bit.b5
    	#define	p01	P2DR.bit.b6
   		
    	#endif
    
    
    
    

#define	test_led	P7DR.bit.b0	

#define	uchar	unsigned char
#define	uint	unsigned int

#define	VD1F	VDCR1.bit.b3
#define	VD2F	VDCR1.bit.b7

#define	stop	SYSCR1.bit.b7=1


#define	high	0xff
#define	low	0x00

#define	input		0x00
#define	output	0xff


#define	start_ad		ADCCR1.bit.b7=1


uchar	temp1;
uint	ad_value;


	
	void	delay(void)
	{
	uint	temp;
	for(temp=0;temp<20000;temp++)
		{__asm("NOP");}
	}
	
	


#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{	
	WDCDR.byte = 0x4e;		//Clear WDT
		
	CGCR.byte=0;				//fcgck=fc/4 according to the datasheet, set the RST pin must be at this clock
	
	
	SYSCR3.bit.b0=1;			//disable RST.
	SYSCR4.byte=0xb2;
	
	

	
	
		
		
		P1CR.byte=output;
		P1DR.byte=low;

		P4CR.byte=output;
//		P4CR.bit.b6=0;
		P4DR.byte=low;
		
		P7CR.byte=output;
		P7DR.byte=low;
		
		P8CR.byte=output;
		P8DR.byte=low;

		P9CR.byte=output;
		P9DR.byte=low;


	
	P4CR.bit.b6=1;		//set P46 as output pin
	
	
	
	POFFCR0.byte=0x00;
	POFFCR1.byte=0x00;
	POFFCR2.byte=0x00;
	POFFCR3.byte=0x00;
	
	KWUCR0.byte=0x00;
	KWUCR1.byte=0x00;
	
	
	EIRL.byte=0x00;	
	
	
	
	
	
		
//		VDCR2.byte=0x05;	//0x05;		//enable VD1 and VD2.
//		VDCR1.byte=0x03;		//SET vd1 is 3.15V and VD2 is 2.85V
	
	VDCR2.byte=0x00;
	VDCR1.byte=0x00;
	
	
	
//wakeup test with P40(KW10)


	P4CR.bit.b0=0;
	P4PU.bit.b0=0;	//1;	//if the wake-up feature is enabled, the built-in pull-up resistors is automatically enabled
	P4PD.bit.b0=1;	//0;
	KWUCR0.bit.b0=1;	//enable kw0 wake up
	KWUCR0.bit.b1=1;	//0;	//LOW wake up


//AD initial

	P4CR.bit.b6=0;	//set P46 as input pin
	P4PU.bit.b6=0;
	P4PD.bit.b6=0;	//disable all built-in pull-up resistors and built-in pull-down resistors
	ADCCR1.byte=0x36;	//set AIN6 as analog input pin
	
	
	ADCCR2.byte=0x03;	//set conversion times to 32 us
//	ADCVRF.byte=0x03;	//set reference voltage to internal VDD
	
	ADCVRF.byte=0x00;	//set reference voltage to internal 2V
//	ADCVRF.byte=0x01;	//set reference voltage to internal 3V
	
	
	
	
//====================================================================================================
//====================================================================================================
//====================================================================================================
	//set UART pin
	// 
	//=========================
	P9CR.bit.b1 = 0x0;  //p91 RX
	P9CR.bit.b0 = 0x1;
	P9FC.bit.b0 = 0x1;  //P90 TX
	
    //=========================
	//set IntRXD  IntTXD
	// 
	//=========================	
	__asm("DI");
	POFFCR1.byte = 0x02;	
	EIRE.byte = 0xC0;// INTTXD0:INTRXD0:INTTBT:INTWUC:Reserved:Reserved:Reserved:Interrupt-master-enableflag
	__asm("EI");
    //=========================
	//set uart config
	// 8,N,1 baudrate= 9600
	//=========================		
	UART1CR2.byte=0x00;	//Receive stop bit = 1
	UART1DR.byte = 0x0C;	//baud rate = 9600
	UART1CR1.byte = 0xc0;//Rx Tx enable,Transmit stop bit length=1,No parity,UART output,Transfer base clock=fcgck
      
		
//====================================================================================================
//====================================================================================================
//====================================================================================================
	
	
	
	while(1)
	{
		
	WDCDR.byte = 0x4e;	//clear WDT
	start_ad;
	
	while(ADCCR2.bit.b7==0){
			WDCDR.byte = 0x4e;	//clear WDT
					};
	

	__C=ADCDRL.byte;
	__B=(ADCDRH.byte&0x03);
	
	ad_value+=__BC;
	ad_value/=2;
	
	temp1++;
	if(temp1>100)
		{temp1=0;
			
		if(ad_value>512)
			{test_led=1;}
		else{test_led=0;};
			
			
			}
			
		
	__BC=	ad_value;	
			
	TD1BUF.byte =__B;
			
	delay();
	
	TD1BUF.byte =__C;
			
	delay();
	
	
	}



}




